#!/bin/sh
# OpenBSD version
# integer scheck inspired from: https://stackoverflow.com/a/16444570
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>

print_usage () {
  echo >&2 "usage: $(basename ${0}) [0..100]"
  exit 1
}

# check if argument given or not (list or set value)
if [ $# -eq 1 ]
then
  # set value (select between ac or bat mode)
  # check if argument is integer between 0,100
  case $1 in
    (*[!0-9]*|'')
      print_usage
      exit
      ;;
    (*)
      if [ "$1" -ge 0 ] && [ "$1" -le 100 ] 2>/dev/null
      then
        # argument given and between 0,100
        case $( sysctl -n hw.power ) in

          (0) # BATTERY
            echo "$1" > ${HOME}/.backlight-bat
            ;;

          (1) # AC
            echo "$1" > ${HOME}/.backlight-ac
            ;;

        esac
        doas wsconsctl display.brightness=$1
      else
        # arg not between 0 and 100
        print_usage
      fi
      ;;
  esac
else
  # no args given, only list values
  case $( sysctl -n hw.power ) in
    (0) # BATTERY
      current=bat
      ;;
    (1) # AC
      current=ac
      ;;
  esac

  for status in ac bat
  do
    if [ "${status}" = "${current}" ]
    then
      echo -e "${status}: ★ \t$( cat ${HOME}/.backlight-${status} )" | tr "[:lower:]" "[:upper:]"
    else
      echo -e "${status}:\t$( cat ${HOME}/.backlight-${status} )" | tr "[:lower:]" "[:upper:]"
    fi
  done
  echo -e "CUR:\t$(doas wsconsctl display.brightness | awk -F= '{ print $2 }')"
fi
