#!/bin/bash
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>

FILE="/tmp/mailtmp.txt"
OLD_SUBJECT="/tmp/mailsubject.txt"

trap "rm ${FILE}; exit" SIGHUP SIGINT SIGTERM

# create empty file
>${FILE}

if [[ -w ${OLD_SUBJECT} ]]; then
  # read subject from file
  oldsubject=$(<${OLD_SUBJECT})
else
  # create empty file
  >$OLD_SUBJECT
  oldsubject="New subject"
fi

# set subject line
kdialog --inputbox "New subject:" "${oldsubject}" >${OLD_SUBJECT}

subject=$(<${OLD_SUBJECT})

# save mail in file
cat $* > ${FILE}

# change subject line
sed -i "s/^Subject: \(.*\)/Subject: ${subject}/" ${FILE}

# return file
cat ${FILE}

# delete email file
rm ${FILE}
