#!/usr/bin/env python3

"""
Author: Dominic OE7DRT <quick.hat4396@qtztsjosmprqmgtunjyf.com>
"""

"""open the lastheard page on brandmeister
"""

import re, argparse, webbrowser

def main():
    """main function"""

    parser = argparse.ArgumentParser(description='Opens a last-heard table on Brandmeister in your browser')
    
    subparser = parser.add_subparsers(dest='selection')    
    
    talkgroup = subparser.add_parser('tg')
    callsign = subparser.add_parser('call')
    dmrid = subparser.add_parser('id')
    
    talkgroup.add_argument('TG', help='Talkgroup', type=int)
    callsign.add_argument('CALLSIGN', help='Callsign', type=str)
    dmrid.add_argument('DMRID', help='DMR-ID (Integer)', type=int)

    args = parser.parse_args()

    if args.selection == 'tg':
        tg_pattern = re.compile("^([1-9]|[1-9][0-9]{1,6})$")
        if tg_pattern.match(str(args.TG)):
            url = 'https://brandmeister.network/?page=lh&DestinationID={}'.format(args.TG)
            #print(url)
        else:
            print("not a valid tg number:", args.TG)
            exit(1)
    
    elif args.selection == 'call':
        call_pattern = re.compile("^[a-zA-Z0-9]{1,3}[0123456789][a-zA-Z0-9]{0,2}[a-zA-Z]$")
        if call_pattern.match(str(args.CALLSIGN)):
            url = 'https://brandmeister.network/?page=lh&SourceCall={}'.format(args.CALLSIGN.upper())
            #print(url)
        else:
            print("not a valid callsign:", args.CALLSIGN)
            exit(1)

    elif args.selection == 'id':
        dmrid_userid_pattern = re.compile("^[0-9]{7}$")
        dmrid_repeater_pattern = re.compile("^[0-9]{6}$")
        if dmrid_userid_pattern.match(str(args.DMRID)):
            url = 'https://brandmeister.network/?page=lh&SourceID={}'.format(args.DMRID)
            #print(url)
        elif dmrid_repeater_pattern.match(str(args.DMRID)):
            url = 'https://brandmeister.network/?page=lh&ContextID={}'.format(args.DMRID)
            #print(url)
        else:
            print("not a valid DMR-ID:", args.DMRID)
            exit(1)
    else:
        parser.print_help()
        exit(1)

    webbrowser.open(url, new=0, autoraise=True)
    #print(url)


if __name__ == "__main__":
    main()
