#!/bin/sh
# generate forum signatures for black and white backgrounds
# files get optimized with optipng, advpng and pngcrush
#   you may want to install them; if you don't have them installed
#   the output files get not optimized
# for random output I utilize a perl script `randomquote.pl` which
# is not my own and the author does not want it to be re-distributed
# so you might want to find something that suits your need
# 
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>
# Last modified: 2024-01-15 02:36
#

# font_path=/usr/local/share/fonts/spleen/
font_path=/usr/share/fonts/spleen
# files create in actual dir _dark.png and _light.png are added to filename
file_prefix=forumsig
quote=$(~/bin/randomquote.pl | fold -sw 76)

# dark
convert -background black -fill \#ddd -font ${font_path}/spleen-32x64.otf \
  -antialias -pointsize 20 label:"$quote" ${file_prefix}_dark.png

# light
convert -background white -fill \#222 -font ${font_path}/spleen-32x64.otf \
  -antialias -pointsize 20 label:"$quote" ${file_prefix}_light.png

missing=""

command -v optipng > /dev/null 2>&1 || { missing="$missing optiping"; }
command -v advpng > /dev/null 2>&1 || { missing="$missing advpng"; }
command -v pngcrush > /dev/null 2>&1 || { missing="$missing pngcrush"; }

if [ -n "$missing" ]
then
  echo >&2 "could not find:$missing"
  exit 1
fi

for file in ${file_prefix}_{dark,light}.png
do
  optipng -nb -nc $file > /dev/null 2>&1
  advpng -z4 $file > /dev/null 2>&1
  pngcrush -rem gAMA -rem alla -rem cHRM -rem iCCP -rem sRGB -rem time -ow $file > /dev/null 2>&1
done
