#!/bin/sh
#
# Saves an incoming email as plain text file (or .eml)
# somewhere in the webservers directories
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>
# Lastmod: 2025-02-23 07:17
# License: MIT

date=`date +%Y%m%d-%H%M%S`
datey=`date +%Y`
datem=`date +%Y-%m_%B`
dated=`date +%Y-%m-%d`
tmpf="/tmp/fullmail-$(echo ${date} | sha1sum -zt | cut -d' ' -f1).tmp"
tmpfs="/tmp/stripped-$(echo ${date} | sha1sum -zt | cut -d' ' -f1).tmp"
folder="/srv/sites/files/repository/private/mails"

cat $* > ${tmpf}

subject="$(grep -m 1 -i "^Subject:" ${tmpf} | cut -d: -f2- | sed "s/^\ //" | tr -Cs "[:alnum:]" "-" | sed "s/-$//" | qprint -d)"
echo >&2 "found subject: $subject"
to="$(grep -i "^Delivered-To:" ${tmpf} | cut -d: -f2- | cut -d@ -f1 | head -n 1 | xargs)"
echo >&2 "found delivered-to: $to"

#: "${VARIABLE:=DEFAULT_VALUE}"
: "${subject:=NoSubjectGiven}"
: "${to:=unknown}"

echo >&2 "subject:      $subject"
echo >&2 "delivered-to: $to"

while read line; do
  case "${line}" in
    From:*|To:*|C[Cc]:*|Delivered-To:*|Date:*|Subject:*|Received:*|Message-ID:*|Content-Type:*|Content-Transfer-Encoding:*|User-Agent:*) echo ${line} >> ${tmpfs};;
    "") (echo && cat $*) >> ${tmpfs};;
    *) ;;
  esac
done < ${tmpf}

filename="${date}_${subject}.txt"
file="${folder}/${to}/${datem}/${filename}"
link="https://$URL/${to}/${filename}"

mkdir -pm 755 ${folder}/${to}/${datem}

mv "${tmpfs}" "${file}"
chmod 644 ${file}
echo >&2 "move to: $file"

echo -e "New mail in archives: ${subject}\n\n<${link}>\n\n-- \nMail sorting script \`${0}\` to your service.\n" | \
mail -s "New mail in archives: ${to}" -. contact@domain.local
