#!/bin/sh
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>
# License: MIT

date=`date +%Y%m%d-%H%M%S`
dated=`date +%Y%m%d`
tmpf="/tmp/fullmail-$(echo ${date} | sha1sum -zt | cut -d' ' -f1).tmp"
tmpfs="/tmp/stripped-$(echo ${date} | sha1sum -zt | cut -d' ' -f1).tmp"
folder="/srv/sites/files/repository/private/mails"

cat $* > ${tmpf}

subject="$(grep -i "^Subject:" ${tmpf} | cut -d: -f2- | sed "s/^\ //" | tr -Cs "[:alnum:]" "-" | sed "s/-$//" | qprint -d)"
to="$(grep -i "^Delivered-To:" ${tmpf} | cut -d: -f2- | cut -d@ -f1 | xargs)"

#: "${VARIABLE:=DEFAULT_VALUE}"
: "${subject:=NoSubjectGiven}"
: "${to:=unknown}"

mkdir -pm 755 ${folder}/${to}/${dated}
ripmime -i ${tmpf} -d ${folder}/${to}/${dated}/ --no-nameless
chmod -f 644 ${folder}/${to}/${dated}/*