#!/usr/bin/env python3

""" sending aprs status packets for my weather station

    Author: Dominic Reich (OE7DRT) <quick.hat4396@qtztsjosmprqmgtunjyf.com>
"""

import aprslib


intervals = (
    ('weeks', 604800),  # 60 * 60 * 24 * 7
    ('days', 86400),    # 60 * 60 * 24
    ('hours', 3600),    # 60 * 60
    ('minutes', 60),
    ('seconds', 1),
)


def get_uptime(granularity=2):
    with open('/proc/uptime', 'r') as u:
        uptime_seconds = int(float(u.readline().split()[0]))

    return(display_time(uptime_seconds, granularity))


def display_time(seconds, granularity=2):
    result = []

    for name, count in intervals:
        value = seconds // count
        if value:
            seconds -= value * count
            if value == 1:
                name = name.rstrip('s')
            result.append("{} {}".format(value, name))
    return ', '.join(result[:granularity])


def test():
    """test function"""
    print('Uptime: ' + get_uptime())


def main():
    """main func"""
    AIS = aprslib.IS("OE7DRT-13", passwd="*****", port=14580)

    #AIS.sendall("OE7DRT-13>APRS,TCPIP*:>Running for " + get_uptime(2) + " on https://wx.oe7drt.com\r\n")
    try:
        AIS.connect()
    except TimeoutError:
        print("Could not send packets - Timeout.")
    except:
        print("An unexpected Error occured:")
    
    AIS.sendall("OE7DRT-13>APRS,TCPIP*:>Weatherpage: https://wx.oe7drt.com\r\n")

if __name__ == "__main__":
    main()
