#!/usr/bin/env bash
# Get last heard time via ham-digital.org
# Author: Dominic Reich, OE7DRT <quick.hat4396@qtztsjosmprqmgtunjyf.com>
#
# Good DX and vy 73 de OE7DRT

command -v w3m > /dev/null 2>&1 || { echo >&2 "w3m not found"; exit 1; }

print_usage () {
  echo >&2 "usage: `basename $0` [dmr_id | callsign]"
  exit 1
}

if [ $# -ne 1 ]
then
  print_usage
fi

getLH () {
  CALL=`echo $1 | tr a-z A-Z`
  FILE=/tmp/$CALL
  OUTFILE=/tmp/${CALL}_LH
  w3m "https://ham-digital.org/dmr-lh.php?callsign=$CALL" > $FILE
  c=`grep $CALL $FILE | wc -l | xargs`

  while [ $c -gt 0 ]
  do
    #OUT=`grep $CALL $FILE | head -n $c | tail -n 1 | awk '{ print $2,$3,$5,$6,$4,$8,$9,$13,$10 }'`
    #OUT=`grep $CALL $FILE | head -n $c | tail -n 1 | awk '{ print $6,"was last heard on",$2,$3,"via",$9 }'`
    OUT=`grep $CALL $FILE | head -n $c | tail -n 1`
    echo $OUT >> $OUTFILE
    ((c--))
  done
  if [ ! -s $OUTFILE ]
  then
    echo No records found for »${CALL}«
    rm ${FILE}
    exit 1
  fi
  sort $OUTFILE
  rm $FILE $OUTFILE
}

getCALLSIGN () {
  ID=$1
  FILE=/tmp/$ID
  w3m "https://ham-digital.org/dmr-userreg.php?usrid=$ID" > $FILE
  CALL=`grep $ID $FILE | awk '{ print $4 }'`
  rm $FILE
  if [ -z $CALL ]
  then
    exit 1
  fi
  getLH $CALL
}

checkID () {
  if [[ ! $1 =~ ^[0-9]{7}$ ]]
  then
    echo >&2 "no valid dmr_id supplied"
    exit 1
  fi
}

if [ "$1" -eq "$1" ] 2>/dev/null
then
  ID="$1"
  checkID $ID
else
  CALL="$1"
fi

if [ ! -z $ID ]
then
  getCALLSIGN $ID
  exit 0
elif [ ! -z $CALL ]
then
  getLH $CALL
  exit 0
else
  print_usage
fi
