## Explained

I tried the quick route by adding a wildcard CNAME record to handle all possible
subdomains quickly. Turns out, that ACME client (Let's Encrypt) does not like that
(or at least: my client that tries to get new certificates).

So I removed it but I had to put around 30 subdomains into the zonefile.
I could have done that quickly with the texteditor of choice but I wanted
something modular, something that I can use later again.

### The procedure

I had all the subdomains n my local DNS server (I'm using split DNS at home)
but OPNSense does not have an export feature in there so I copied them all
with the mouse and pasted them into a textfile `vhosts`.

Now I had something like this:

```
cadence.oe7drt.net
it-tools
cadence.oe7drt.net
kamera
cadence.oe7drt.net
host3
cadence.oe7drt.net
host4
...
```

They've been all in lines on the webinterface but now they are all separated
by newlines. As they are consistently changing lines I decided to only extract
every 2nd line, which worked pretty well.

```console
$ awk 'NR % 2 == 0' vhosts | xargs
```

I copied the result into my new script and executed it.

Et voilà!
The script pushed them all to the DNS server blazing fast. I'm sure we could tighten
them all together and send them with only one request but that is an option for someone
else ;-P

My quick-n-dirty solutions have never been elegant but they work most of the time (even if
they work only for a short time, they help me overcome the weirdest encounters) \*lol*

Read more (sources)

- <https://docs.hetzner.cloud/reference/cloud#zone-rrsets-create-an-rrset>