#!/bin/sh
# Creates a timelapse video of all the images stored in
# ~/timelapse - done by the other script wxcam-update.sh
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>
# Created: 2025-02-21 20:26
# Lastmod: 2025-04-26 12:15
#
# Changelog:
#  - 2025-03-20 05:56
#     no idea what i changed here
#  - 2025-04-26T12:13:53+0200
#     changed framerate from 15 to 10
#
# -pix_fmt yuv420p

(ffmpeg -y -loglevel info -framerate 10 -pattern_type glob \
  -i "/home/dominic/timelapse/*.jpg" -c:v libtheora -q:v 7 -an \
  -pix_fmt yuv420p /srv/http/pub/wx/timelapse.ogv && \
ffmpeg -y -loglevel info -framerate 10 -pattern_type glob \
  -i "/home/dominic/timelapse/*.jpg" -c:v libx264 -an \
  -tune zerolatency -movflags +faststart -crf 24 \
  -pix_fmt yuv420p /srv/http/pub/wx/timelapse.mp4 && \
ffmpeg -y -loglevel info -framerate 10 -pattern_type glob \
  -i "/home/dominic/timelapse/*.jpg" -c:v libvpx-vp9 -an \
  -movflags +faststart -b:v 2M -maxrate 3M -bufsize 3M \
  -pix_fmt yuv420p /srv/http/pub/wx/timelapse.webm) >> /home/dominic/ffmpeg-logfile.txt

if [ "$?" -eq 0 ]; then
  cp /srv/http/pub/wx/timelapse.webm /srv/http/pub/wx/timelapse/timelapse-$(date +"%Y%m%d").webm
  rm -f /home/dominic/timelapse/*.jpg
  rm -f /home/dominic/ffmpeg-logfile.txt
fi