#!/bin/sh
# Updates the WX image on the weather station page.
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>
# Created: 2025-02-21 20:12
# Lastmod: 2025-02-23 06:59 2025-08-17 10:38

# file where the last timestamp is saved
FILE=/tmp/wxcam-timestamp

# wait for TDIFF seconds before sending another email warning (default 1800 seconds (30minuts))
TDIFF=$((1800))

if [ ! -w ${FILE} ]; then
    # create empty file
    >${FILE}
    date +%s > ${FILE}
fi

hour=$(date +%k | sed "s/^ //")

# echo $hour

curl -f -s -o /tmp/wx.jpg http://wxcam.lan/jpg

if [ "$?" -eq 0 ]; then
    magick /tmp/wx.jpg -gravity SouthWest -pointsize 30 -font NeoSpleen-Nerd-Font -fill yellow -annotate 0 " $(LANG="""C""" date +"""%a, %Y-%m-%d %H:%M""") · Längenfeld · OE7DRT-13" /srv/http/pub/wx/wxcam.jpg

    if [ "$hour" -gt 3 ] && [ "$hour" -lt 23 ]; then
          cp /srv/http/pub/wx/wxcam.jpg /home/dominic/timelapse/tmp-$(date +"%Y%m%d-%H%M%S").jpg
    fi
else
    old_timestamp=$(<${FILE})
    new_timestamp=$(date +%s)
    diff=$(expr "$new_timestamp" - "$old_timestamp")

    if [[ "$diff" -ge "${TDIFF}" ]]; then
        echo -e "The weather webcam is not reachable.\nI'll wait for ${TDIFF} seconds for the next notification!\n\nhttp://wxcam.lan/mjpeg/1\nhttp://wxcam.lan/jpg\n\nhttps://wxcam.oe7drt.net/mjpeg/1\nhttps://wxcam.oe7drt.net/jpg\n\nCurl exit-code: ${?}" | mutt -s "Weather webcam offline" -- "dominic@mm.st"
        date +%s > ${FILE}
    fi
fi