#!/bin/env python

"""Print pretty csv data on terminal
vim: ft=python

Author:         Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>
Created:        2025-02-05T19:49:59+0100
Last modified:  2025-02-05T19:50:07+0100

Usage:
------
    Use with arguments (filename of csv data).
    ./pretty_csv <filename>
"""

import sys
import os
import pandas as pd


def main():

    if len(sys.argv) <= 1:
        print("Sorry, what is it?")
        exit(1)
    else:
        filename=sys.argv[1]

    if os.path.isfile(filename) and os.access(filename, os.R_OK):
        csv_file = pd.read_csv(filename, dtype=str)

        print(csv_file)
    else:
        print("File ›{}‹ not found or not readable. Aborting.".format(filename))
        exit(1)


if __name__ == "__main__":
    main()
