#!/bin/sh
# 2024-05-26
# lastmod: 2024-10-05
# Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>

BFILE=/srv/http/blocked.txt
IPFILE=~/ips

if [[ $USER == "root" ]]; then
	echo >&2 "User must not be root! Exiting"
	exit 1
fi

if [[ ! -r $IPFILE ]]; then
	echo >&2 "Could not find/open ip file: ${IPFILE}"
	exit 1
fi

COUNT=$(wc -l ${IPFILE} | cut -d' ' -f1)
OLDNUM=$(sudo ipset --terse -L | grep "Number of entries:" | cut -d: -f2 | xargs)

while read ip; do sudo ipset -exist -A badips "$ip"; done < $IPFILE

FILEBACKUP=3

TODAY=$(ls ${BFILE}.$(date +%Y%m%d)-* 2>/dev/null| wc -l)
if [ ${FILEBACKUP} -ne 0 ]; then
	# sudo cp ${BFILE} ${BFILE}.$(date +%Y%m%d)
	sudo cp ${BFILE} ${BFILE}.$(date +%Y%m%d)-$(expr ${TODAY} + 1)
fi

BACKUPCOUNT=$(expr $(ls ${BFILE}.* | wc -l) - $TODAY - 1)
BACKUPSTODELETE=$(expr ${BACKUPCOUNT} - ${FILEBACKUP})
if [ ${BACKUPCOUNT} -gt ${FILEBACKUP} ]; then
	for f in $(ls -tr ${BFILE}.* | head -${BACKUPSTODELETE})
	do
		sudo rm ${f}
	done
fi

# save to blocklist file in webroot
sudo ipset -output save -L | grep add | awk '{ print $3 }' | sort -g | sudo tee ${BFILE} 1>/dev/null

# save to /etc/ipset.conf
sudo ipset save -file /etc/ipset.conf

# Test if current ip is in the badips set
# sudo ipset -q -T badips $(who | tail -1 | awk -F '[()]' '{ print $2 }')
sudo ipset -T badips $(who | tail -1 | awk -F '[()]' '{ print $2 }')

#sudo ipset --terse -L

NEWNUM=$(sudo ipset --terse -L | grep "Number of entries:" | cut -d: -f2 | xargs)

rm -f $IPFILE

echo "Added $((${NEWNUM}-${OLDNUM}))/${COUNT} IPs (${OLDNUM} → ${NEWNUM})"
