#!/bin/sh
# Practical script to adjust my monitor layout on ma X1 laptop
# Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>

internal="eDP-1"
external="HDMI-1"

print_usage () {
  echo >&2 "usage: $(basename ${0}) [normal;wide;dup]"
  exit 0
}

if [ $# -eq 1 ]
then
  case "$1" in
    "normal"|"n"|"norm")
      xrandr --output "$external" --off --output "$internal" --auto
      dunstify "Multimonitor setup" "set to normal ($internal)"
      ;;
    "wide"|"w")
      xrandr --output "$external" --set audio force-dvi --mode 1920x1080
      xrandr --output "$internal" --auto --output "$external" --right-of "$internal"
      dunstify "Multimonitor setup" "set to wide ($internal + $external (right-of))"
      ;;
    "duplicate"|"dup"|"d")
      xrandr --output "$external" --set audio force-dvi --mode 1920x1080
      xrandr --output "$internal" --auto --output "$external" --same-as "$internal"
      dunstify "Multimonitor setup" "set to duplicate ($internal; $external)"
      ;;
    *)
      dunstify -u critical "Multimonitor setup failed" "no such operation: ${1}"
      ;;
  esac
else
  print_usage
fi
