#!/usr/bin/env python3

""" Sort the blacklist ip list file into CIDR networks

Author: Dominic Reich “OE7DRT”
        <quick.hat4396@qtztsjosmprqmgtunjyf.com>

Usage:  Run the program, paths are fixed (specified below)

        Unfinished and aborted - I don't need something like this any more.
        So i published it here - someone might use it and adopt or enhance it.
        Or not. I don't care ;)

"""

import os
import ipaddress

def main():
    """main function
    """

    ipfile = "/etc/ipset.conf"
    blacklist = os.path.expanduser('~') + "/blacklist.txt"

    if os.path.isfile(ipfile) and os.access(ipfile, os.R_OK):
        with open("/etc/ipset.conf", "r") as f:
            lines=f.readlines()
            ips=[]
            for line in lines:
                if 'add badips' in line:
                    ips.append(line.split(' ')[2].strip())
    else:
        print("Could not open ipset file")
        exit(1)

    f.close()

    # convert into ipaddress objects
    ips = [ipaddress.IPv4Address(_) for _ in ips]
    cidrs = list(ipaddress.collapse_addresses(ips))

    with open(blacklist, "w") as file:
        file.write('\n'.join(str(i) for i in cidrs))

    file.close()


if __name__ == "__main__":
    main()