#!/bin/sh

# Sync the downloads from downloads.winlink.org to a local folder
# (and copy the most recent downloads into my own archive)
#
# Author:   Dominic Reich (OE7DRT) <quick.hat4396@qtztsjosmprqmgtunjyf.com>
# Lastmod:  2024-10-06

# we need wget for this, check if its installed or abort
command -v wget > /dev/null 2>&1 || { echo >&2 "wget not found"; exit 1; }

ARCHIVE="/srv/http/pub/hamradio/Winlink"

print_usage () {
  echo >&2 "usage: $(basename $0)"
  echo >&2 "       run without arguments, paths are fixed in the code"
  echo >&2 "       (change them if you like/need to)"
  exit 1
}

if [[ $USER == "root" ]]
then
  echo >&2 "Must not be root to run! Aborting..."
  exit 1
fi

if [ $# -ne 0 ]
then
  print_usage
fi

# echo "debug: go into directory $ARCHIVE"
cd ${ARCHIVE}

# echo "debug: get/sync folders"
wget --exclude-directories="**/SCS USB Driver 2.08.24 WHQL Certified" \
  --quiet --mirror --accept zip,exe \
  https://downloads.winlink.org/

# echo "debug: copy vara files"
cp -u downloads.winlink.org/VARA\ Products/*zip archive/

# echo "debug: copy winlink files"
cp -u downloads.winlink.org/User\ Programs/{Winlink_Express*,Standard_Forms}.zip archive/
