#!/bin/sh
#
# Author: Dominic Reich <quick.hat4396@qtztsjosmprqmgtunjyf.com>

suspicfile=~/suspic
tmpfile=/tmp/ips

clean_up() {
  echo -n "Removing tmp file..."
  rm -f $tmpfile
  rm -f $suspicfile
  if [ "$?" -eq "0" ]; then
    echo " done"
  else
    echo " *** FAILED ***"
    echo "Could not delete tmp file \`$tmpfile\`"
    exit 1
  fi
}

# inspect url files first by hand
echo -n "Inspecting first..."
ret="$(alacritty -e $EDITOR $suspicfile)"

if [ "$?" -eq "0" ]; then
  echo " done"
else
  echo " *** FAILED ***"
  ecoh "Could not open editor. Aborting..."
  clean_up
  exit 1
fi

# awk '{ print $1 }' $suspicfile | sort -h | uniq > ips

# Remove false-positives (like requests to the /posts URL which should be valid)
# I used some bad words in some filenames like "admin-panel..."
sed '/posts\//d' $suspicfile | awk '{ print $1 }' | sort -h | uniq > $tmpfile

ips_1=`wc -l $tmpfile | awk '{ print $1 }'`

#ip=`ifconfig | grep inet | egrep -v "inet6|127" | grep 0xffffff00 | awk '{ print $2 }'`
ip=`curl -s ifconfig.me`
echo "My remote ip address is $ip"

sed -i "/$ip/d" $tmpfile
ips_2=`wc -l $tmpfile | awk '{ print $1 }'`

removed_ips=`expr "$ips_1" - "$ips_2"`

echo "Removed $removed_ips ip address(es)"

echo -n "Inspecting ip file..."
ret="$(alacritty -e $EDITOR $tmpfile)"

if [ "$?" -eq "0" ]; then
  echo " done"
else
  echo " *** FAILED ***"
  echo "Could not open editor. Aborting..."
  clean_up
  exit 1
fi

echo -n "Sending to bor..."
ret="$(scp -q $tmpfile bor:)"

if [ "$?" -eq "0" ]; then
  echo " done"
else
  echo " *** FAILED ***"
  echo "Could not send the new ips to the OpenBSD server. Aborting..."
  clean_up
  exit 1
fi

echo -n "Sending to celeste..."
ret="$(scp -q $tmpfile celeste:)"

if [ "$?" -eq "0" ]; then
  echo " done"
else
  echo " *** FAILED ***"
  echo "Could not send the new ips to the Archlinux server. Aborting..."
  clean_up
  exit 1
fi

clean_up

echo "Ok all done."
